from TransientImage import *
from TimeSlicePlot import *
from HistogramPlot import *

import matplotlib.pyplot as plt
import sys
import os.path
import json

if(len(sys.argv)>=2):		
	filename = sys.argv[1]
else:
	#raise Exception("please specify filename to load!")
	path = r"C:\Users\klein\Documents\Work\Projects\Transient Challenge\pbrt-v3\bin\\"
	filename = path + "Geometry.ti"

dir, fn = os.path.split(filename)	
title = " - "+fn+" - "+dir

i = TransientImage(filename)

#print properties
try:
	if len(i.imageProperties) > 0:
		js = json.loads(i.imageProperties.replace("\\", "/"))
		print(json.dumps(js, sort_keys=True, indent=2))
	print("Top Left: ", i.topLeft)
	print("Top Right: ", i.topRight)
	print("Bottom Left: ", i.bottomLeft)
	print("Bottom Right: ", i.bottomRight)
	print("")
	print("uRes: ", i.uResolution)
	print("vRes: ", i.vResolution)
	print("tRes: ", i.numBins)
	print("tMin: ", i.tMin)
	print("tMax: ", i.tMax)
except AttributeError:
	pass


b = HistogramPlot(i, title)
a = TimeSlicePlot(i, title)

plt.show()